var gdjs;(function(u){const l=new u.Logger("ResourceLoader"),c=new u.Logger("ResourceLoader - debug").enable(!1),f=(d,e,s)=>{if(d.startsWith("data:")||d.startsWith("blob:"))return d;const r=d.indexOf("?")===-1?"?":"&";return d+r+e+"="+s},M=d=>d.startsWith("https://project-resources.gdevelop.io/")||d.startsWith("https://project-resources-dev.gdevelop.io/");class _{constructor(e){this.isFinished=!1;this.sceneName=e,this.onProgressCallbacks=new Array,this.onFinishCallbacks=new Array}registerCallback(e,s){if(this.isFinished){e();return}this.onFinishCallbacks.push(e),s&&this.onProgressCallbacks.push(s)}onProgress(e,s){for(const r of this.onProgressCallbacks)r(e,s)}onFinish(){this.isFinished=!0;for(const e of this.onFinishCallbacks)e()}}class v{async loadResource(e){}async processResource(e){}getResourceKinds(){return["internal-in-game-editor-only-svg"]}unloadResource(e){}dispose(){}}const i=class{constructor(e,s,r,n){this._sceneLoadingStates=new Map;this._sceneToLoadQueue=new Array;this._spineAtlasManager=null;this._spineManager=null;this.currentLoadingSceneName="";this.currentSceneLoadingProgress=0;this._isLoadingInForeground=!0;this._runtimeGame=e,this._resources=new Map,this._globalResources=r,this.setResources(s,r,n),this._imageManager=new u.ImageManager(this),this._soundManager=new u.SoundManager(this),this._fontManager=new u.FontManager(this),this._jsonManager=new u.JsonManager(this),this._bitmapFontManager=new u.BitmapFontManager(this,this._imageManager),this._model3DManager=new u.Model3DManager(this),this._svgManager=new v,u.SpineAtlasManager&&u.SpineManager&&(this._spineAtlasManager=new u.SpineAtlasManager(this,this._imageManager),this._spineManager=new u.SpineManager(this,this._spineAtlasManager));const t=[this._imageManager,this._soundManager,this._fontManager,this._jsonManager,this._bitmapFontManager,this._model3DManager,this._svgManager];this._spineAtlasManager&&t.push(this._spineAtlasManager),this._spineManager&&t.push(this._spineManager),this._resourceManagersMap=new Map;for(const a of t)for(const o of a.getResourceKinds())this._resourceManagersMap.set(o,a)}getRuntimeGame(){return this._runtimeGame}setResources(e,s,r){this._globalResources=s,this._sceneLoadingStates.clear();for(const n of r)this._sceneLoadingStates.set(n.name,{resourceNames:n.usedResources.map(t=>t.name),status:"not-loaded"});this._sceneToLoadQueue.length=0;for(let n=r.length-1;n>=0;n--){const t=r[n],a=t.resourcesPreloading||"inherit";(a==="inherit"?this._runtimeGame.getSceneResourcesPreloading():a)==="at-startup"&&this._sceneToLoadQueue.push(new _(t.name))}this._resources.clear();for(const n of e)!n.file||this._resources.set(n.name,n)}async loadAllResources(e){let s=0;await i.processAndRetryIfNeededWithPromisePool([...this._resources.values()],i.maxForegroundConcurrency,i.maxAttempt,async r=>{await this._loadResource(r),await this._processResource(r),s++,e(s,this._resources.size)});for(const r of this._sceneLoadingStates.values())r.status="ready"}async loadResources(e,s){let r=0;await i.processAndRetryIfNeededWithPromisePool(e,i.maxForegroundConcurrency,i.maxAttempt,async n=>{const t=this._resources.get(n);t&&(await this._loadResource(t),await this._processResource(t)),r++,s(r,this._resources.size)})}async loadGlobalAndFirstSceneResources(e,s){const r=this._sceneLoadingStates.get(e);if(!r){l.warn(`Can't load resource for unknown scene: "`+e+'".');return}let n=0;const t=[...this._globalResources,...r.resourceNames];await i.processAndRetryIfNeededWithPromisePool(t,i.maxForegroundConcurrency,i.maxAttempt,async a=>{const o=this._resources.get(a);if(!o){l.warn('Unable to find resource "'+a+'".');return}await this._loadResource(o),await this._processResource(o),n++,s(n,t.length)}),r.status="ready"}async loadAllSceneInBackground(){if(!this.currentLoadingSceneName){for(c.log("Loading all scene resources, in background.");this._sceneToLoadQueue.length>0;){c.log(`Still resources of ${this._sceneToLoadQueue.length} scene(s) to load: ${this._sceneToLoadQueue.map(s=>s.sceneName).join(", ")}`);const e=this._sceneToLoadQueue[this._sceneToLoadQueue.length-1];e!==void 0&&(this.currentLoadingSceneName=e.sceneName,this.areSceneAssetsLoaded(e.sceneName)?this._sceneToLoadQueue.pop():(c.log(`Loading (but not processing) resources for scene ${e.sceneName}.`),await this._doLoadSceneResources(e.sceneName,async(s,r)=>e.onProgress(s,r)),c.log(`Done loading (but not processing) resources for scene ${e.sceneName}.`),this._sceneToLoadQueue.splice(this._sceneToLoadQueue.findIndex(s=>s===e),1),e.onFinish()))}c.log("Scene resources loading finished."),this.currentLoadingSceneName=""}}async _doLoadSceneResources(e,s){const r=this._sceneLoadingStates.get(e);if(!r){l.warn(`Can't load resource for unknown scene: "`+e+'".');return}let n=0;await i.processAndRetryIfNeededWithPromisePool(r.resourceNames,this._isLoadingInForeground?i.maxForegroundConcurrency:i.maxBackgroundConcurrency,i.maxAttempt,async t=>{const a=this._resources.get(t);if(!a){l.warn('Unable to find resource "'+t+'".');return}await this._loadResource(a),n++,this.currentSceneLoadingProgress=n/r.resourceNames.length,s&&await s(n,r.resourceNames.length)}),r.status="loaded"}async _loadResource(e){const s=this._resourceManagersMap.get(e.kind);if(!s){l.warn('Unknown resource kind: "'+e.kind+'" for: "'+e.name+'".');return}await s.loadResource(e.name)}async loadAndProcessSceneResources(e,s){if(this.areSceneAssetsReady(e))return;await this.loadSceneResources(e,s);const r=this._sceneLoadingStates.get(e);if(!r){l.warn(`Can't load resource for unknown scene: "`+e+'".');return}let n=0;for(const t of r.resourceNames){const a=this._resources.get(t);if(!a){l.warn('Unable to find resource "'+t+'".');continue}await this._processResource(a),n++,s&&await s(n,r.resourceNames.length)}r.status="ready"}async loadSceneResources(e,s){c.log(`Prioritization of loading of resources for scene ${e} was requested.`),this._isLoadingInForeground=!0;const r=this._prioritizeScene(e);return new Promise((n,t)=>{if(!r){this._isLoadingInForeground=!1,c.log(`Loading of resources for scene ${e} was immediately resolved.`),n();return}r.registerCallback(()=>{c.log(`Loading of resources for scene ${e} just finished.`),this._isLoadingInForeground=!1,n()},s)})}dispose(){for(const e of this._resourceManagersMap.values())e.dispose()}unloadSceneResources({unloadedSceneName:e,newSceneName:s}){if(!e)return;c.log(`Unloading of resources for scene ${e} was requested.`);const r=this._getResourcesByKindOnlyUsedInUnloadedScene({unloadedSceneName:e,newSceneName:s});for(const[t,a]of this._resourceManagersMap){const o=r.get(t);if(o){c.log(`Unloading of resources of kind ${t} for scene ${e}: `,o.map(g=>g.name).join(", "));for(const g of o)a.unloadResource(g)}}c.log(`Unloading of resources for scene ${e} finished.`);const n=this._sceneLoadingStates.get(e);n&&(n.status="not-loaded")}unloadAllResources(){c.log("Unloading of all resources was requested.");for(const e of this._resources.values()){const s=this._resourceManagersMap.get(e.kind);s&&s.unloadResource(e)}for(const e of this._sceneLoadingStates.values())e.status="not-loaded";c.log("Unloading of all resources finished.")}_prioritizeScene(e){const s=this._sceneLoadingStates.get(e);if(!s)return null;if(s.status==="loaded"||s.status==="ready")return c.log(`Scene ${e} is already loaded. Skipping prioritization.`),null;const r=this._sceneToLoadQueue.findIndex(t=>t.sceneName===e);let n;return r!==-1?(n=this._sceneToLoadQueue[r],this._sceneToLoadQueue.splice(r,1),this._sceneToLoadQueue.push(n)):(n=new _(e),this._sceneToLoadQueue.push(n)),this.loadAllSceneInBackground(),n}async _processResource(e){const s=this._resourceManagersMap.get(e.kind);if(!s){l.warn('Unknown resource kind: "'+e.kind+'" for: "'+e.name+'".');return}await s.processResource(e.name)}getSceneLoadingProgress(e){return e===this.currentLoadingSceneName?this.currentSceneLoadingProgress:this.areSceneAssetsLoaded(e)?1:0}areSceneAssetsLoaded(e){const s=this._sceneLoadingStates.get(e);return s?s.status==="loaded"||s.status==="ready":!1}areSceneAssetsReady(e){const s=this._sceneLoadingStates.get(e);return s?s.status==="ready":!1}getResource(e){return this._resources.get(e)||null}getFullUrl(e){this._runtimeGame.isInGameEdition()&&e.startsWith("file://")&&(e=f(e,"cache",""+Date.now()));const{gdevelopResourceToken:s}=this._runtimeGame._options;return!s||!M(e)?e:f(e,"gd_resource_token",encodeURIComponent(s))}checkIfCredentialsRequired(e){return this._runtimeGame._options.gdevelopResourceToken?!1:!!M(e)}getSoundManager(){return this._soundManager}getImageManager(){return this._imageManager}getFontManager(){return this._fontManager}getBitmapFontManager(){return this._bitmapFontManager}getJsonManager(){return this._jsonManager}getModel3DManager(){return this._model3DManager}getSpineManager(){return this._spineManager}getSpineAtlasManager(){return this._spineAtlasManager}injectMockResourceManagerForTesting(e,s){this._resourceManagersMap.set(e,s)}_getResourcesByKindOnlyUsedInUnloadedScene({unloadedSceneName:e,newSceneName:s}){const r=this._sceneLoadingStates.get(e);if(!r)return new Map;const n=new Set(r.resourceNames);for(const[a,o]of this._sceneLoadingStates.entries())a!==e&&(a===s||o.status==="loaded"||o.status==="ready")&&o.resourceNames.forEach(g=>{n.delete(g)});const t=new Map;return n.forEach(a=>{const o=this._resources.get(a);if(!o)return;const g=o.kind,m=t.get(g);m?m.push(o):t.set(g,[o])}),t}static processWithPromisePool(e,s,r){const n=[],t=[];let a=0,o=0;return new Promise((g,m)=>{const R=()=>{if(e.length===0){g({results:n,errors:t});return}for(;a<s&&o<e.length;){const S=e[o++];a++,r(S).then(p=>n.push(p)).catch(p=>t.push({item:S,error:p})).finally(()=>{a--,o===e.length&&a===0?g({results:n,errors:t}):R()})}};R()})}static async processAndRetryIfNeededWithPromisePool(e,s,r,n){const t=await i.processWithPromisePool(e,s,n);t.errors.length!==0&&l.warn("Some assets couldn't be downloaded. Trying again now.");for(let a=1;a<r&&t.errors.length!==0;a++){const o=await i.processWithPromisePool(e,s,n);t.results.push.apply(t.results,o.results),t.errors=o.errors}return t}};let h=i;h.maxForegroundConcurrency=20,h.maxBackgroundConcurrency=5,h.maxAttempt=3,u.ResourceLoader=h})(gdjs||(gdjs={}));
//# sourceMappingURL=ResourceLoader.js.map
